use AppleScript version "2.4"
use scripting additions
use script "Dialog Toolkit Plus" version "1.1.3"

property applicationsFolderName : "Applications"
property appNameEnd : ".app" -- CHANGE TO ".app"
property appNameStart : "Jalview" -- can be "" or null
property appIconFile : "app.icns" -- this is a fallback icon
property arrowFile : "Arrow.icns"
property applicationsFolderIconFile : "ApplicationsFolderIcon.icns"
property homeApplicationsFolder : null
property systemApplicationsFolder : null
property longUserName : null
property userName : null
property homeFolder : null
property isInstallation : false
property doing : ""
property forAllUsers : false
property targetFolder : null
property addAppToDock : false
property sourceApp : null
property sourceAppName : null
property duplicateApp : null
property duplicatedApp : false
-- for startup progress bar
use framework "Foundation"
use framework "AppKit"
property thisProgressWindow : missing value
property thisProgressIndicator : missing value
property primaryTextField : missing value
property secondaryTextField : missing value
property hitStop : false

on run
	bringToFront()
	setProgressText("Installer starting", "Installer is starting up, please wait...")
	userSetup()
	appSetup({})
	
	if not askTheUser() then
		return 100
	end if
	try
		if not forAllUsers then
			makeHomeApplicationsFolder()
		end if
	on error number 1
		return
	end try
	
	setProgressText("Installing", "Installing " & sourceAppName)
	stepProgress(1, 2)
	
	if forAllUsers then
		set targetFolder to systemApplicationsFolder as alias
	else
		set targetFolder to homeApplicationsFolder as alias
	end if
	
	if isInstallation and not sourceApp is null then
		duplicateFile(sourceApp)
	else
		openFinder()
	end if
	
	setProgressText("Installer complete", "Finished installing " & sourceAppName)
	stepProgress(2, 2)
	
	postDuplication()
	
	finishedDialog()
	return
end run

(*
on open droppedItems
	userSetup()
	appSetup(droppedItems)
	if not askTheUser() then
		return 100
	end if
	try
		if not forAllUsers then
			makeHomeApplicationsFolder()
		end if
	on error number 1
		return
	end try
	if forAllUsers then
		set targetFolder to systemApplicationsFolder as alias
	else
		set targetFolder to homeApplicationsFolder as alias
	end if
	repeat with droppedItem in droppedItems
		duplicateFile(droppedItem)
	end repeat
	if not (isInstallation and not sourceApp is null) then
		openFinder()
	end if
	postDuplication()
	return
end open
*)

on setProgressText(title, message)
	set progress description to title
	set progress additional description to message
end setProgressText

on stepProgress(step, totalSteps)
	set progress total steps to totalSteps
	set progress completed steps to step
	delay 0.5
end stepProgress

on endProgress()
	set progress total steps to 0
	set progress completed steps to 0
	set progress description to ""
	set progress additional description to ""
end endProgress

on userSetup()
	set longUserName to long user name of (system info)
	set userName to short user name of (system info)
	set homeFolder to home directory of (system info)
	-- set homeApplicationsFolder to (path to applications folder from user domain) -- this method automatically creates the folder. might not be necessary so set later
	set systemApplicationsFolder to path to applications folder from system domain
end userSetup

on appSetup(candidatesList)
	tell application "Finder" to set pathToMyFolder to container of (path to me) as alias
	
	set pathToMe to POSIX path of (path to me)
	if (pathToMe as string) ends with ".app/" then
		set pathToIcons to pathToMe & "Contents/Resources/"
	else
		set pathToIcons to POSIX path of pathToMyFolder
	end if
	set appIconFile to pathToIcons & appIconFile
	set arrowFile to pathToIcons & arrowFile
	set applicationsFolderIconFile to pathToIcons & applicationsFolderIconFile
	
	if appNameStart is null then
		set appNameStart to ""
	end if
	
	if length of candidatesList = 0 then
		tell application "Finder" to set candidatesList to (every item of folder pathToMyFolder whose (name ends with appNameEnd) and (name starts with appNameStart))
	end if
	set foundApp to false
	repeat with candidate in candidatesList
		if (not foundApp and not (path to me as string) = (candidate as string)) then
			set sourceApp to candidate
			set sourceAppName to name of candidate
			if sourceAppName ends with appNameEnd then
				set sourceAppName to text 1 thru ((sourceAppName's length) - (appNameEnd's length)) of sourceAppName
			end if
			set foundApp to true
		end if
	end repeat
end appSetup

on askTheUser()
	local accViewWidth, leftInset, iconSize, action, doing, theButtons, minWidth, theRule1, theTop, addToDockCheckbox, newWidth, theRule2, allUsersText, installFor, appPOSIXPath, thisIconPath, thisIconExists, theAppIcon, theArrow, theFolderIcon, theLabel, unused, allControls, buttonName, installingFor, addingToDock
	
	set accViewWidth to 400
	set leftInset to 16
	set iconSize to 32
	
	set isInstallation to not sourceApp = null
	
	if isInstallation then
		set action to "Install"
		set doing to "installation"
	else
		set action to "Copy"
		set doing to "copying files"
	end if
	set {theButtons, minWidth} to create buttons {"Cancel", action} default button 1 given class btns:2
	if minWidth > accViewWidth then set accViewWidth to minWidth -- make sure buttons fit
	set maxWidth to (accViewWidth - leftInset)
	
	set {theRule1, theTop} to create rule 8 rule width accViewWidth
	if isInstallation then
		set {addToDockCheckbox, theTop, newWidth} to create checkbox "Add " & sourceAppName & " to current user's Dock?" bottom theTop + 8 max width maxWidth left inset leftInset with initial state
		set {theRule2, theTop} to create rule (theTop + 8) rule width accViewWidth
	end if
	set allUsersText to action & " for all users"
	set {installFor, theTop} to create matrix {allUsersText, action & " for current user only (" & longUserName & ")"} bottom (theTop + 8) max width maxWidth left inset leftInset initial choice allUsersText
	
	if isInstallation then
		set appPOSIXPath to POSIX path of (sourceApp as alias)
		set thisIconPath to getIconPathForApp(appPOSIXPath)
		tell application "System Events" to set thisIconExists to exists (file thisIconPath)
		if not thisIconExists then
			set thisIconPath to appIconFile
		end if
		try
			set {theAppIcon, unused} to create image view thisIconPath left inset leftInset bottom (theTop + 20) view width iconSize view height iconSize align image (top left aligned)
			set {theArrow1, unused} to create image view arrowFile left inset (leftInset + iconSize) bottom (theTop + 20) view width iconSize view height iconSize align image (top left aligned)
			set {theFolderIcon, theTop} to create image view applicationsFolderIconFile left inset (leftInset + 2 * iconSize) bottom (theTop + 20) view width iconSize view height iconSize align image (top left aligned)
		on error eMsg number eNum
			display dialog "Installer error! " & eNum & return & eMsg
			return false
		end try
		set {theLabel, unused} to create label (sourceAppName) & " installation" bottom (theTop - iconSize / 2 - 10) left inset (leftInset + 3 * iconSize + 8) max width maxWidth - 3 * iconSize - 8 control size large size aligns left aligned
		set allControls to {installFor, addToDockCheckbox, theRule1, theRule2, theAppIcon, theArrow1, theFolderIcon, theLabel}
	else
		try
			set {theArrow2, unused} to create image view arrowFile left inset leftInset bottom (theTop + 20) view width iconSize view height iconSize align image (top left aligned)
			set {theFolderIcon, theTop} to create image view applicationsFolderIconFile left inset (leftInset + iconSize) bottom (theTop + 20) view width iconSize view height iconSize align image (top left aligned)
		end try
		set {theLabel, unused} to create label "Copy files to " & applicationsFolderName & " folder" bottom (theTop - iconSize / 2 - 10) left inset (leftInset + 2 * iconSize + 8) max width maxWidth - 2 * iconSize - 8 control size large size aligns left aligned
		set allControls to {installFor, theRule1, theArrow2, theFolderIcon, theLabel}
	end if
	
	setProgressText("Installer ready", "Please make a selection to install " & sourceAppName)
	stepProgress(0, 2)
	
	bringToFront()
	
	set {buttonName, {installingFor, addingToDock}} to display enhanced window "Install " & (sourceAppName) acc view width accViewWidth acc view height theTop acc view controls allControls buttons theButtons with align cancel button
	
	if buttonName is "Cancel" then
		cancelDialog()
		return false
	end if
	
	set forAllUsers to installingFor is allUsersText
	
	try
		set addAppToDock to (addingToDock and true) -- "and true" coerces a boolean
	on error
		set addAppToDock to false
	end try
	
	return true
end askTheUser

on bringToFront()
	tell me
		delay 0.2
		activate
	end tell
end bringToFront

on cancelDialog()
	bringToFront()
	setProgressText("Installation cancelled", "")
	stepProgress(2, 2)
	display dialog "Cancelled " & doing with title "Cancelled" giving up after 5 with icon caution buttons {"OK"}
	quit
end cancelDialog

on finishedDialog()
	bringToFront()
	setProgressText("Installation finished", "")
	stepProgress(2, 2)
	-- display dialog "Finished " & doing with title "Completed" giving up after 3 buttons {"OK"}
	quit
end finishedDialog

on errorDialog(message)
	bringToFront()
	setProgressText("Installation error", "An error occurred")
	stepProgress(1, 2)
	display dialog message with icon caution buttons {"Exit"}
	quit
end errorDialog

on makeHomeApplicationsFolder()
	set homeAppFolder to ((homeFolder as string) & applicationsFolderName)
	
	try
		tell application "Finder"
			
			if exists alias (homeAppFolder) then
				set targetFolder to null
				try
					set targetFolder to original item of alias homeAppFolder
					-- only continuing here if homeAppFolder is a symbolic link, otherwise going to "on error"
					if not (exists folder (targetFolder as string)) then -- symlink target doesn't exist or isn't a folder
						error ("'" & homeAppFolder & "'" & return & "is a symbolic link to" & return & "'" & (targetFolder as string) & "'" & return & "which isn't a folder, so cannot install here." & return & "Exiting the Installer.") number 701
					end if
				on error number -1728
					-- we get here due to homeAppFolder not being a symbolic link (because "original item" above fails)
					set targetFolder to alias homeAppFolder
				end try
				if (exists alias (targetFolder as string)) and not (exists folder (targetFolder as string)) then -- targetFolder exists but isn't a folder
					error ("'" & targetFolder & "'" & return & "isn't a folder, so cannot install here." & return & "Exiting the Installer.") number 701
				end if
				set homeAppFolder to (targetFolder as string)
			end if
						
			if not (exists folder (homeAppFolder)) then
				display dialog "Your home Applications folder doesn't exist." & return & "Shall I create it?" buttons {"No", "Yes"}
				if button returned of result = "Yes" then
					set homeApplicationsFolder to make new folder at homeFolder with properties {name:applicationsFolderName}
				else
					error number 702
				end if
			else
				set homeApplicationsFolder to homeAppFolder				
			end if
		end tell
	on error errorMessage number errorNumber
		if errorNumber = 701 then
			errorDialog(errorMessage)
		end if
		if errorNumber = 702 then
			cancelDialog()
		end if
	end try
	
	bringToFront()
	return true
end makeHomeApplicationsFolder

on duplicateFile(fileAlias)
	try
		tell application "Finder"
			activate
			set filename to name of fileAlias
			set newAppAlias to null
			if (forAllUsers) then
				-- if user cancels an admin request for this duplicate then newAppAlias becomes unset
				set newAppAlias to (duplicate (fileAlias as string) to folder targetFolder)
			else
				set newAppAlias to (duplicate (fileAlias as string) to folder targetFolder)
			end if
			
			-- catch an unset newAppAlias which can only occur if the user cancels an admin request (for /Applications)
			try
				set dummyVar to newAppAlias
			on error
				-- newAppAlias not set
				set newAppAlias to null
				error "User cancelled operation" number 2
			end try
			
			if isInstallation and fileAlias as string is sourceApp as string and newAppAlias is not null then
				set duplicateApp to newAppAlias
				set duplicatedApp to true
			end if
		end tell
	on error errorMessage
		errorDialog("Error occurred copying" & return & fileAlias & return & "to" & return & targetFolder & return & (errorMessage as string))
	end try
end duplicateFile

on openFinder()
	tell application "Finder"
		activate
		open targetFolder
	end tell
end openFinder

on selectInFinder(appPath)
	tell application "Finder"
		activate
		open parent of (appPath as alias)
		set selection to (appPath as alias)
	end tell
end selectInFinder

on postDuplication()
	if addAppToDock and duplicatedApp then
		addToDock(sourceAppName, duplicateApp)
		selectInFinder(duplicateApp)
	end if
end postDuplication

on addToDock(appName, appPath)
	try
		--			tell application "Dock" to quit
		set appPOSIXPath to POSIX path of (appPath as string)
		tell application "Dock" to quit
		
		do shell script "defaults write com.apple.dock persistent-apps -array-add '<dict><key>tile-data</key><dict><key>file-data</key><dict><key>_CFURLString</key><string>" & (appPOSIXPath as string) & "</string><key>_CFURLStringType</key><integer>0</integer></dict></dict></dict>'"
		(*  this block doesn't seem to work so using the shell script one-liner above instead
		set prefsFile to (((path to preferences from user domain) as text) & "com.apple.dock.plist") as alias
		tell application "System Events"
			set dockPath to (prefsFile as text)
			set dockRec to (value of property list file dockPath)
		end tell
		set appURLPath to "file://" & appPosixPath
		set newAppData to {|_CFURLString|:appURLPath, |_CFURLStringType|:0}
		set newTileData to {|dock-extra|:false, |file-data|:newAppData, |file-label|:appName, |file-type|:2, showas:3}
		set newMenuAppItem to {|tile-data|:newTileData}
		tell application "System Events" to set |persistent-apps| of dockRec to ((|persistent-apps| of dockRec) & {newMenuAppItem}) --add the app
		*)
		
		tell application "Dock" to activate
		(* comment out the on error as there's always an error
				on error errorMessage
					display dialog "ERROR! " & return & errorMessage as string
		*)
	end try
end addToDock

on getIconPathForApp(appPOSIXPath) -- takes unquoted POSIX path ending with '.app/' for app bundle
	set infoPlist to appPOSIXPath & "Contents/Info.plist"
	try
		set iconName to (do shell script "defaults read " & quoted form of infoPlist & " CFBundleIconFile")
	on error
		return null
	end try
	if iconName does not end with ".icns" then set iconName to iconName & ".icns"
	return appPOSIXPath & "Contents/Resources/" & iconName
end getIconPathForApp
